/*
# VRPN iOS server 
# This server receives data from a iOS device by using a UDP connection
# written by Luis Ballesteros, AI3D Colivri Uniandes / May 2012 (Colombia)
# lg.ballesteros94@uniandes.edu.co
*/

#ifndef VRPN_IOSDEVICE_H
#define VRPN_IOSDEVICE_H

#include "vrpn_Analog.h"
#include "vrpn_Button.h"


#include <windows.h>
#include <stdio.h>
#include <vector>

using namespace std;

class VRPN_API vrpn_iOSDevice: public vrpn_Analog, public vrpn_Button
{
public:
    vrpn_iOSDevice (const char * name, const char * port, vrpn_Connection * c);

    //~vrpn_iOSDevice ();

    // Called once through each main loop iteration to handle
    // updates.
    virtual void mainloop ();

protected:
    //virtual vrpn_int32 get_report(void);	// Try to read a report from the device
    void	clear_values(void);	// Clear the Analog and Button values*/

	struct timeval _timestamp;	// Time of the last report from the device

    // send report iff changed
    virtual void report_changes (vrpn_uint32 class_of_service
	      = vrpn_CONNECTION_LOW_LATENCY);
    // send report whether or not changed
    virtual void report (vrpn_uint32 class_of_service
	      = vrpn_CONNECTION_LOW_LATENCY);

	//print bits
	void printbitssimple(__int16);
	
	//filter zero values
	void filterValue(short *,short *);
};
#endif

